<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fn="fn"
    xmlns:pl="http://product-live.com"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    version="3.0"
    exclude-result-prefixes="xs fn pl">
    
    <xsl:output method="xml" indent="yes" encoding="UTF-8" cdata-section-elements="" />

    <!-- Custom functions are declared like this. You must use the prefix pl: and add the xmlns:pl="http://product-live.com" in the header like in this example -->
    <xsl:function name="pl:add-ean-to-text">
        <!-- xsl:param are used as function inputs -->
        <xsl:param name="text" />
        <!-- Simply return what you want, here it just add Product-Live to the input text -->
        <xsl:value-of select="concat('ean:', $text)" />
    </xsl:function>
    
    <xsl:template match="/">
        <Identifiers>
            <xsl:for-each select="/Table/Items/Item">
                <Id><xsl:value-of select="pl:add-ean-to-text(Identifier[@key='ean'])"/></Id>
            </xsl:for-each>
        </Identifiers>
    </xsl:template>
</xsl:stylesheet>